#version 330 core
in vec2 vUV;
in vec4 vColor;
flat in int vBlendMode;

uniform sampler2D uTexture;

out vec4 FragColor;

void main()
{
    vec4 texel = texture(uTexture, vUV);

    if (vBlendMode == 2)
    {
        if (texel.a <= 0.5) discard;
    }

    FragColor = texel * vColor;
}
