#version 330 core

layout(location = 0) in vec2 aUnit;          // (0,0),(0,1),(1,1),(1,0)
layout(location = 4) in vec3 iV00;
layout(location = 5) in vec3 iV01;
layout(location = 6) in vec3 iV11;
layout(location = 7) in vec3 iV10;
layout(location = 8) in vec4 iColor;         // GL_CURRENT_COLOR rgba
layout(location = 9) in vec4 iL1L2V1V2;      // L1,L2,V1,V2

uniform mat4 uProj;
uniform mat4 uView;                          // (hoặc uWorld*uView theo engine)

out VS_OUT {
    vec2 uv;
    vec4 color;
} vs;

void main(){
    float tu = aUnit.x;
    float tv = aUnit.y;

    // Bilinear map unit->quad (4 corner positions)
    vec3 A = mix(iV00, iV01, tv);
    vec3 B = mix(iV10, iV11, tv);
    vec3 pos = mix(A, B, tu);
    gl_Position = uProj * uView * vec4(pos, 1.0);

    // UV nội suy giữa (L1,V1) <-> (L2,V2)
    float u = mix(iL1L2V1V2.x, iL1L2V1V2.y, tu);
    float v = mix(iL1L2V1V2.z, iL1L2V1V2.w, tv);
    vs.uv = vec2(u, v);

    vs.color = iColor;
}
