#version 430 core
in vec4 v_color0;
in vec2 v_effUV;
in vec2 v_baseUV;

uniform sampler2D s0;        // unit0: effect/chrome texture
uniform sampler2D uMaskTex;  // unit1: diffuse alpha mask

out vec4 FragColor;

void main(){
    vec4 eff = texture(s0, v_effUV) * v_color0;

    // NEW: alpha mask theo diffuse gốc
    float maskA = texture(uMaskTex, v_baseUV).a;

    vec4 c = vec4(eff.rgb, eff.a * maskA);
    if(c.a < 0.2) discard;

    FragColor = c;
}
