#version 430 core

layout(location = 0) in vec3 aPos;
layout(location = 1) in vec3 aNorm;
layout(location = 2) in vec2 aTex;
layout(location = 3) in uint aBone;

layout(location = 4) in vec4 i_bodyLight;
layout(location = 5) in vec4 i_lightPosition;
layout(location = 6) in vec4 i_meshUV;      // (uAdd, vAdd, _, _)
layout(location = 7) in int  i_enableLight;
layout(location = 8) in int  i_boneBaseIndex;
layout(location = 9) in vec4 i_setting1;    // (sx, sy, planeZ, _)
layout(location = 10) in vec4 i_setting2;   // (origin.xyz, _)

uniform mat4 uProj;
uniform mat4 uView;

layout(std430, binding=0) buffer Bones { vec4 b4[]; };

out vec4 v_color0;
out vec2 v_texcoord0;
out vec4 v_setting1;
out vec4 v_setting2;

void main() {
    // aBone đã là offset hàng đầu (đơn vị: vec4 row)
    int base = i_boneBaseIndex + int(aBone);
    vec4 r0 = b4[base + 0];
    vec4 r1 = b4[base + 1];
    vec4 r2 = b4[base + 2];

    // world position (1-bone)
    vec3 wp = vec3(dot(r0.xyz, aPos) + r0.w,
                   dot(r1.xyz, aPos) + r1.w,
                   dot(r2.xyz, aPos) + r2.w);

    // tham số chiếu
    float sx     = i_setting1.x;
    float sy     = i_setting1.y;
    float planeZ = i_setting1.z;
    vec3  origin = i_setting2.xyz;

    // chiếu (Z là up) giống CalcShadowPosition
    vec3 p = wp;
    p -= origin;
    p.x += p.z * (p.x + sx) / (p.z - sy);
    p += origin;
    p.z  = planeZ;

    gl_Position = uProj * uView * vec4(p, 1.0);

    // bóng đen mờ; alpha lấy từ i_bodyLight.w
    v_color0    = vec4(0.0, 0.0, 0.0, clamp(i_bodyLight.w, 0.0, 0.2));
    v_texcoord0 = aTex + i_meshUV.xy;

    // pass-through để FS giữ giao diện thống nhất
    v_setting1 = i_setting1;
    v_setting2 = i_setting2;
}
