#version 330 core
uniform sampler2D uTexture;

in vec2 TexCoord;
in vec4 VertexColor;
flat in int BlendMode; // giữ để debug hoặc mở rộng

out vec4 FragColor;

void main()
{
    // Lấy màu texture và nhân với vertex color/alpha
    vec4 texColor = texture(uTexture, TexCoord);
    vec4 finalColor = texColor * VertexColor;

    // Alpha test (thay cho glAlphaFunc cũ)
    if (finalColor.a < 0.1)
        discard;

    // Không xử lý blend ở shader
    // BlendFunc đã set ở CPU side (EnableAlphaBlend, EnableAlphaBlendMinus, ...)
    FragColor = finalColor;
}
