#version 330 core
in vec2 TexCoord;
in vec3 Color;
in float Alpha;
flat in int Digit;
flat in int TexType;

uniform sampler2D uFontAtlas;     // số 0..9
uniform sampler2D uFontAtlasHit;  // chữ HIT

out vec4 FragColor;

void main()
{
    vec4 tex;
    // đảo V (tránh render bị lộn ngược so với atlas cũ)
    vec2 base = vec2(TexCoord.x, 1.0 - TexCoord.y);

    if (TexType == 0) {
        // mỗi ký tự: 16x16 px trên atlas 256x32
        const vec2 cell = vec2(16.0/256.0, 16.0/32.0);
        vec2 uv = base * cell + vec2(cell.x * float(Digit), 0.0);
        tex = texture(uFontAtlas, uv);
    } else {
        // HIT atlas → size 27/32 x 15/16
        vec2 uv = base * vec2(27.0/32.0, 15.0/16.0);
        tex = texture(uFontAtlasHit, uv);
    }

    if (tex.a < 0.1) discard;
    FragColor = vec4(tex.rgb * Color, tex.a * Alpha);
}
